document.addEventListener("DOMContentLoaded", () => {
    const toggle = document.getElementById("themeToggle");
    const icon = document.querySelector(".theme-icon");
  
    const prefersDark = window.matchMedia("(prefers-color-scheme: dark)");
    const saved = localStorage.getItem("theme");
    const isDark = saved ? saved === "dark" : prefersDark.matches;
  
    const currentTheme = isDark ? "dark" : "light";
    document.documentElement.setAttribute("data-theme", currentTheme);
  
    if (toggle) toggle.checked = isDark;
  
    function updateIcon(theme) {
      if (icon) {
        icon.textContent = theme === "dark" ? "dark_mode" : "light_mode";
      }
    }
  
    function updateThemeIcons(theme) {
      document.querySelectorAll(".theme-icon-img").forEach(img => {
      const src = theme === "dark" ? img.dataset.dark : img.dataset.light;
      img.src = src;
    });
}

    updateIcon(currentTheme);
    updateThemeIcons(currentTheme);

    if (toggle) {
      toggle.addEventListener("change", () => {
        const theme = toggle.checked ? "dark" : "light";
        document.documentElement.setAttribute("data-theme", theme);
        localStorage.setItem("theme", theme);
        updateIcon(theme);
        updateThemeIcons(theme);  // swap all theme images
        
        const link = document.getElementById("themeStylesheet");
        if (link) {
          link.setAttribute("href", `assets/css/theme-vivoquant-${theme}.css`);
        }
      });
    }
  });
  